/*------------------------------------------------------------------------------*
 * File Name: Wizard.cpp	 													*
 * Creation: GJL 11/11/03														*
 * Purpose: OriginC Source CPP file containing sample code for the Wizard		*
 * Dialog Builder example.														*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007				*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <Dialog.h>
#include "WizardRes.h"

// Base WizPage class
class WizPage : public PropertyPage
{
public:

	// Constructor for base WizPage class
	WizPage(int nID) : PropertyPage(nID) { }

	// Event handler when WizPage becomes active (inherited by all WizPage derived classes)
	BOOL OnActiveWizPage()
	{
		int iWizPageNum = GetID() - IDD_FIRSTPAGE + 1;
		printf("WizPage%d Active\n", iWizPageNum);
		return TRUE;		
	}
};

// Derived WizPage class for WizPage1
class WizPage1 : public WizPage
{
public:

	// Constructor for WizPage1 class
	WizPage1(int nID) : WizPage(nID) { }

	// InitMsgMap function setting up event handler map for WizPage1
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitWizPage)
		PAGE_ON_ACTIVE(OnActiveWizPage)
		ON_BN_CLICKED(IDC_BUTTON1, OnClickToggleButton)
	EVENTS_END
	
	// Event handlers for WizPage1
	BOOL OnInitWizPage()
	{
		out_str("WizPage1 Init");
		m_btnCheckBox = GetItem(IDC_CHECK1);
		m_btnCheckBox.Check = 1;
		return TRUE;
	}

	BOOL OnClickToggleButton(Control ctrl)
	{
		out_str("Click Toggle Button");
		m_btnCheckBox.Check = mod(m_btnCheckBox.Check + 1, 2);
		return TRUE;
	}

	// Data member controls on WizPage1
	Button m_btnCheckBox;
};

// Derived WizPage class for WizPage2
class WizPage2 : public WizPage
{
public:

	// Constructor for WizPage2 class
	WizPage2(int nID) : WizPage(nID) { }

	// InitMsgMap function setting up event handler map for WizPage2
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitWizPage)
		PAGE_ON_ACTIVE(OnActiveWizPage)
		ON_BN_CLICKED(IDC_BUTTON2, OnClickUpperCaseButton)
	EVENTS_END
	
	// Event handlers for WizPage2
	BOOL OnInitWizPage()
	{
		out_str("WizPage2 Init");
		m_ebxText = GetItem(IDC_EDIT1);
		m_ebxText.Text = "Enter text to upper case";
		return TRUE;
	}

	BOOL OnClickUpperCaseButton(Control ctrl)
	{
		out_str("Click Upper Case Button");
		m_ebxText.Text.MakeUpper();
		return TRUE;
	}

	// Data member controls on WizPage2
	Edit m_ebxText;
};

// Derived WizPage class for WizPage3
class WizPage3 : public WizPage
{
public:

	// Constructor for WizPage3 class
	WizPage3(int nID) : WizPage(nID) { }

	// InitMsgMap function setting up event handler map for WizPage3
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitWizPage)
		PAGE_ON_ACTIVE(OnActiveWizPage)
		ON_BN_CLICKED(IDC_BUTTON3, OnClickOutputButton)
	EVENTS_END

	// Event handlers for WizPage3
	BOOL OnInitWizPage()
	{
		out_str("WizPage3 Init");
		m_cmbxStooges = GetItem(IDC_COMBO1);
		m_cmbxStooges.SetCurSel(0);
		return TRUE;
	}

	BOOL OnClickOutputButton(Control ctrl)
	{
		out_str("Click Output Button");
		string str;
		m_cmbxStooges.GetLBText(m_cmbxStooges.GetCurSel() ,str);
		str.Format("You selected %s.",str);
		str.Write(WRITE_MESSAGE_BOX);
		return TRUE;
	}

	// Data member controls on WizPage3
	ComboBox m_cmbxStooges;
};

// WizPage place holder class
class WizSheet : public WizardSheet
{
public:

	// Constructor for WizardSheet class
	WizSheet()
	{
		m_WizPage1.SetID(IDD_FIRSTPAGE);
		m_WizPage2.SetID(IDD_SECONDPAGE);
		m_WizPage3.SetID(IDD_THIRDPAGE);
		AddPage(m_WizPage1);
		AddPage(m_WizPage2);
		AddPage(m_WizPage3);
		AddPathControl(45); // Add Wizard Map on left, 45% of the width of the main dialog
	}

	// Initialize message maps for each WizPage
	void InitMaps()
	{
		m_WizPage1.InitMsgMap();
		m_WizPage2.InitMsgMap();
		m_WizPage3.InitMsgMap();
	}

	// Data members of PropertySheet are WizPage objects
	WizPage1 m_WizPage1;
	WizPage2 m_WizPage2;
	WizPage3 m_WizPage3;
};

// Main dialog class
class WizPageDialog : public Dialog
{
public:

	// Constructor for main Dialog
	WizPageDialog(int ID) : Dialog(ID, "Wizard.DLL")
	{
		SetResizingStyle(RESIZE_DEPENDENCY_DOMINANT_DIALOG);
	}

	// Function to launch main Dialog
	int WizardDoModal(HWND hWnd)
	{
		InitMsgMap();
		return DoModal(hWnd, DLG_MODAL_WITH_KEY);
	}

	// InitMsgMap function setting up event handlers for main Dialog
	EVENTS_BEGIN
		PAGE_ON_INIT(Init)
		PAGE_ON_BACK(OnClickBack)
		PAGE_ON_NEXT(OnClickNext)
		PAGE_ON_CANCEL(OnClickCancel)
		PAGE_ON_FINISH(OnClickFinish)
	EVENTS_END

	// Event handlers for main Dialog
	BOOL Init()
	{
		out_str("WizPage Dialog Init");
		m_Sheet.Create(IDC_PAGE_PLACEHOLDER, *this);
		m_Sheet.InitMaps();
		return TRUE;
	}

	BOOL OnClickBack()
	{
		out_str("Click Back Button");
		return TRUE;
	}

	BOOL OnClickNext()
	{
		out_str("Click Next Button");
		return TRUE;
	}

	BOOL OnClickCancel()
	{
		out_str("Click Cancel Button");
		return TRUE;
	}

	BOOL OnClickFinish()
	{
		out_str("Click Finish Button");
		return TRUE;
	}

	// Data member of main Dialog is PropertySheet (place holder)
	WizSheet m_Sheet;
};

// Function to launch main Wizard dialog
void Wizard()
{
	WizPageDialog wdlg(IDD_WIZARD);
	wdlg.WizardDoModal(GetWindow());
}